<?php
/*REVE Chat is powerful and intuitive real-time customer engagement software.*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ControllerPagesExtensionSmartargetWhatsappContactUsManager extends AController {

    public $data = array ();
    private $error = array ();

    public function main()
    {
        $this->document->addStyle(
            array(
                'href' => 'https://smartarget.online/settings/styles.css?ver=1234551',
                'rel' => 'stylesheet',
                'media' => 'screen',
            )
        );

        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('smartarget_whatsapp_contact_us/smartarget_whatsapp_contact_us');
        $this->document->setTitle($this->language->get('smartarget_whatsapp_contact_us_name'));
        $this->data['heading_title'] = $this->language->get('smartarget_whatsapp_contact_us_name');

        $this->document->initBreadcrumb(array(
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE,
        ));

        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('extension/smartarget_whatsapp_contact_us_manager'),
            'text' => $this->language->get('smartarget_whatsapp_contact_us_name'),
            'separator' => ' :: ',
            'current' => true
        ));

        $form = new AForm();
        //Set the form
        $form->setForm( array(
            'form_name' => 'smartarget_whatsapp_contact_us_form',
        ));

        //Set form name and id
        $form_data['smartarget_whatsapp_contact_us_form']['id'] = 'smartarget_whatsapp_contact_us_form';
        //Create a form open tag
        $form_data['smartarget_whatsapp_contact_us_form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'smartarget_whatsapp_contact_us_form',
            'action' => $this->html->getSecureURL('extension/smartarget_whatsapp_contact_us_manager/insert'),
            'attr' => 'class="aform form-horizontal"',
        ));

        $this->loadModel('extension/smartarget_whatsapp_contact_us_manager');
        $result = $this->model_extension_smartarget_whatsapp_contact_us_manager->getSmartargetWhatsappContactUsData();

        $this->view->batchAssign( $form_data );
        $this->view->assign('smartarget_whatsapp_contact_us_data', $result);
        $this->view->assign('appName', 'Smartarget Whatsapp - Contact Us');
        $this->view->assign('platform', 'AbanteCart');
        $this->processTemplate('pages/extension/smartarget_whatsapp_contact_us_manager.tpl' );

    }


    public function insert(){

        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('smartarget_whatsapp_contact_us/smartarget_whatsapp_contact_us');
        $this->document->setTitle($this->language->get('smartarget_whatsapp_contact_us_name'));
        $this->data['heading_title'] = $this->language->get('smartarget_whatsapp_contact_us_name');

        $this->document->initBreadcrumb(array(
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE,
        ));

        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('extension/smartarget_whatsapp_contact_us_manager'),
            'text' => $this->language->get('smartarget_whatsapp_contact_us_name'),
            'separator' => ' :: ',
            'current' => true
        ));

        $form = new AForm();
        //Set the form
        $form->setForm( array(
            'form_name' => 'smartarget_whatsapp_contact_us_form',
        ));
        //Set form name and id
        $form_data['smartarget_whatsapp_contact_us_form']['id'] = 'smartarget_whatsapp_contact_us_form';
        //Create a form open tag
        $form_data['smartarget_whatsapp_contact_us_form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'smartarget_whatsapp_contact_us_form',
            'action' => $this->html->getSecureURL('extension/smartarget_whatsapp_contact_us_manager/insert')
        ));
        $form_data['smartarget_whatsapp_contact_us_form']['submit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get('button_connect'),
            'style' => 'button1',
        ));


        $form_data['smartarget_whatsapp_contact_us_form']['fields']['license']['field'] = $form->getFieldHtml(
            array('type'  => 'textarea',
                'name'  => 'license',
                'value' => $this->data['license'],
                'style' => 'large-field'
            ));

        // do the database query operation
        $smartarget_whatsapp_contact_us_data = $this->request->post;
        $this->loadModel('extension/smartarget_whatsapp_contact_us_manager');
        $result = $this->model_extension_smartarget_whatsapp_contact_us_manager->connectSmartargetWhatsappContactUs($smartarget_whatsapp_contact_us_data);
        $this->processTemplate('pages/extension/smartarget_whatsapp_contact_us_manager.tpl' );

        $this->redirect($this->html->getSecureURL('extension/smartarget_whatsapp_contact_us_manager/'));
    }

}
